using Microsoft.VisualBasic;
using System;
using MicroFour.StrataFrame.Business;
using MicroFour.StrataFrame.Security;
using MicroFour.StrataFrame.UI.Windows.Forms;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;
using System.Data.SqlClient;
using System.Runtime.Serialization;


namespace StrataFlix.Business
{
	[Serializable()]public partial class MovieItemsBO : StrataFlixBaseBO
	{
		
		
		#region " Constructors "
		
		/// <summary>
		/// Initializes a new instance of the MovieItemsBO class.
		/// </summary>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public MovieItemsBO()
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the MovieItemsBO class.
		/// </summary>
		/// <param name="Container">The IContainer to which this object will be added.</param>
		/// <remarks></remarks>
		[System.Diagnostics.DebuggerNonUserCodeAttribute()]public MovieItemsBO(System.ComponentModel.IContainer Container)
		{
			//This call adds the component to the given container.
			Container.Add(this);
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Initializes a new instance of the MovieItemsBO class.
		/// </summary>
		/// <param name="info">The SerializationInfo for the object.</param>
		/// <param name="context">The StreamingContext for the source stream.</param>
		/// <remarks></remarks>
		protected MovieItemsBO(SerializationInfo info, StreamingContext context) : base(info, context)
		{
			//This call is required by the Component Designer.
			this.InitializeComponent();
			//-- Add the necessary handlers
			this.AddHandlers();
		}
		
		/// <summary>
		/// Adds the necessary handlers for the MovieItemsBO class.
		/// </summary>
		/// <remarks></remarks>
		private void AddHandlers()
		{
			this.CheckRulesOnCurrentRow += new MicroFour.StrataFrame.Business.BusinessLayer.CheckRulesOnCurrentRowEventHandler(MovieItemsBO_CheckRulesOnCurrentRow);
			this.SetDefaultValues += new MicroFour.StrataFrame.Business.BusinessLayer.SetDefaultValuesEventHandler(MovieItemsBO_SetDefaultValues);
		}
		
		#endregion
		
		#region " Event Handlers "
		
		/// <summary>
		/// Checks the business rules on the current row
		/// </summary>
		/// <param name="e"></param>
		/// <remarks></remarks>
		private void MovieItemsBO_CheckRulesOnCurrentRow(MicroFour.StrataFrame.Business.CheckRulesEventArgs e)
		{
			
		}
		
		/// <summary>
		/// Sets the default values for a new row
		/// </summary>
		/// <remarks></remarks>
		private void MovieItemsBO_SetDefaultValues()
		{
			mvi_CreatedAt = DateTime.Now;
			mvi_CreatedBy = MicroFour.StrataFrame.Security.SecurityBasics.CurrentUser.UserPK;
		}
		
		#endregion
		
		#region " Protected Methods "
		
		/// <summary>
		/// Provide additional reflection property descriptors
		/// </summary>
		/// <returns></returns>
		/// <remarks></remarks>
		protected override MicroFour.StrataFrame.Business.FieldPropertyDescriptor[] GetCustomBindablePropertyDescriptors()
		{
			return new FieldPropertyDescriptor[] {new ReflectionPropertyDescriptor("mvi_Genre", typeof(MovieItemsBO)), new ReflectionPropertyDescriptor("mvi_Format", typeof(MovieItemsBO))};
		}
		
		#endregion
		
		#region " Public Propeties "
		
		/// <summary>
		/// Represents the media format of the movie item.  This is only valid if the item type
		/// is of a media format type.
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		[Browsable(false), BusinessFieldDisplayInEditor(), Description("Media Format"), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]public MovieMediaFormats mvi_Format
		{
			get
			{
				if (this.Count > 0)
				{
					return ((MovieMediaFormats) mvi_ItemData);
				}
				else
				{
					return MovieMediaFormats.Unknown;
				}
			}
			set
			{
				if (this.Count > 0)
				{
					mvi_ItemData = System.Convert.ToInt32(value);
				}
			}
		}
		
		/// <summary>
		/// Represents the genre of the movie item.  This is only valid if the item type
		/// is of a genre type.
		/// </summary>
		/// <value></value>
		/// <returns></returns>
		/// <remarks></remarks>
		[Browsable(false), BusinessFieldDisplayInEditor(), Description("Genre"), DesignerSerializationVisibility(DesignerSerializationVisibility.Hidden)]public MovieGenre mvi_Genre
		{
			get
			{
				if (this.Count > 0)
				{
					return ((MovieGenre) mvi_ItemData);
				}
				else
				{
					return MovieGenre.Unknown;
				}
			}
			set
			{
				if (this.Count > 0)
				{
					mvi_ItemData = System.Convert.ToInt32(value);
				}
			}
		}
		
		#endregion
		
	}
	
}
